#include <p30fxxxx.h>
#include <spi.h>

/************************************************************************
*     Function Name :  ConfigIntSPI2                                    *
*     Description   :  This Function Configures Interrupt and sets      *
*                      Interrupt Priority                               *
*     Parameters    :  unsigned int config                              *
*     Return Value  :  None                                             *
************************************************************************/

/* The following devices support SPI2 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__)  || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) ||  defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)   

void ConfigIntSPI2( unsigned int config)
{
    IFS1bits.SPI2IF = 0;               /* Clear IF bit  */
    IPC6bits.SPI2IP=(config &0x0007);  /* assign interrupt priority to 
                                          IPC register */

    IEC1bits.SPI2IE=(config &0x0008)>>3;/*Interrupt Enable/Disable bit 
                                          IEC Register */
        
}

#endif
